-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.02.10
-- 
-- add all physical system domains to db table - used in admin pages
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     create this cool feature
--
-- *******************************************************************************
--
-- select * from et_format_domain_physical;
-- delete from et_format_domain_physical;
 
 insert into et_format_domain_physical (domain_id_physical, description, editsize, editmaxlength) 
 values 
-- A
	('ZPD_application', 	'Appliation Code',			5,5),
-- B
	('ZPD_bigNBR9', 		'Big Number',				9, 9),
	('ZPD_bigNBR11', 		'Big Number',				11, 11),
-- C
	('ZPD_catalogID', 		'Catalog ID',				9, 9),
	('ZPD_category', 		'Category',					32, 32),
	('ZPD_columname', 		'Column Name',				64, 64),
	('ZPD_columntitle', 	'Column Title',				64, 64),
	('ZPD_collection', 		'Collection',				32, 32),
	('ZPD_caption', 		'Caption',					64, 64),
	('ZPD_columnheading', 	'Column Heading',			512, 512),
	('ZPD_commandstring', 	'Commandstring',			512, 512),
	('ZPD_config', 			'Configuration ID',			16, 16),
	('ZPD_configValue',		'Configuration Value',		64, 64),
	('ZPD_constraint', 		'Constraint',				16, 16),
	('ZPD_callable', 		'Callable Object',			32, 32),
	('ZPD_checkbox', 		'Checkbox',					1, 1),
	('ZPD_connection', 		'Connection',				16, 16),
 -- D   
	('ZPD_date10', 			'Date',						10, 10),
	('ZPD_description', 	'Description',				30, 30),
	('ZPD_domain', 			'Domain ID',				50, 50),
	('ZPD_defaultvalue', 	'Default Value',			50, 50),
	('ZPD_digit', 			'Digit',					1, 1),
-- E    
	('ZPD_email', 			'eMail',					64, 64),
	('ZPD_edittype', 		'Edittype',					64, 64),
-- F    
	('ZPD_filename', 		'Filename',					64, 64),
-- G    
	('ZPD_GUID', 			'GUID',						32, 32),
-- H    
	('ZPD_humanname', 		'Human/Personal Name',		64, 64),
-- I    
	('ZPD_instance', 		'Instance Name',			16, 16),
	('ZPD_instanceKEY', 	'Catalog ID+Instance Name',	26, 26),
-- L    
	('ZPD_loglink', 		'Logical Link',				32, 32),
	('ZPD_label', 			'Label',					64, 64),
	('ZPD_language', 		'Language',					2, 2),
	('ZPD_lookup', 			'Lookup',					16, 16),
-- M    
	('ZPD_menu', 			'Menu',						10, 10),
	('ZPD_messageID', 		'Message ID',				9,	9),
	('ZPD_messagestring', 	'Message String',			256, 256),
-- O    
	('ZPD_objectname', 		'Object Name',				64, 64),
	('ZPD_ordinalNBR', 		'Ordinal Number',			3, 3),
	('ZPD_operandVAL', 		'Operand Value',			64, 64),
-- P    
	('ZPD_password', 		'Password',					32, 32),
	('ZPD_paramID', 		'Parameter ID',				32, 32),
	('ZPD_paramVAL', 		'Parmeter Value',			64, 64),
	('ZPD_paramlong', 		'Parameter long Value',		128, 128),
	('ZPD_phone', 			'Phone',					32, 32),
-- S    
	('ZPD_session',			'Session ID',				32, 32),
	('ZPD_smallNBR2', 		'Small Number',				2, 2),
	('ZPD_smallNBR3', 		'Small Number',				3, 3),
	('ZPD_smallNBR5', 		'Small Number',				5, 5),
	('ZPD_sortorder', 		'Sortorder',				3, 3), 
	('ZPD_sqlclause', 		'SQL Clause',				512, 512),
-- T    
	('ZPD_transaction', 	'Transaction',				16, 16),
	('ZPD_typeN', 			'Numeric Type', 			1, 1),
	('ZPD_typeNN', 			'Numeric Type',				2, 2),
	('ZPD_typeX', 			'Character Type',			1, 1),
	('ZPD_typeXXX', 		'Character Type',			3, 3),
-- U    
	('ZPD_userID', 			'User ID',					16, 16),	
	('ZPD_username', 		'User ID',					64, 64),
	('ZPD_UCAstring', 		'User Comm Area String',	512,512),
	('ZPD_usergroup', 		'Usergroup',				32, 32)
as loadval
on DUPLICATE KEY UPDATE
	description = loadval.description,
	editsize = loadval.editsize,
	editmaxlength = loadval.editmaxlength;
 